#============================================================================== 
# ** Ruby.Math
#------------------------------------------------------------------------------
# Description:
# ------------
# Miscellaneous new methods for the Math module
#  
# Method List:
# ------------
# A (Ackermann function)
# cw_between_angles?
# ccw_between_angles?
# cw_percent_between_angles
# ccw_percent_between_angles
#==============================================================================

MACL::Loaded << 'Ruby.Math'

module Math
  #-------------------------------------------------------------------------
  # * Name      : Ackermann function
  #   Info      : returns the Natural Number of an A(m,n) Integer
  #   Author    : Me(tm)
  #   Call Info : m as Integer, n as Integer, both 0 or positive.
  #-------------------------------------------------------------------------  
  def Math.A(m,n)
    raise ArgumentError.new('Ackermann: No negative values allowed.') if m < 0 or n < 0
    return n + 1 if m == 0
    return Math.A(m - 1, 1) if n == 0
    return Math.A(m - 1, Math.A(m, n - 1))
  end
  #-------------------------------------------------------------------------
  # * Name      : Angle Between Angles (Clockwise)
  #   Info      : Returns boolean of angle between 2 angles
  #   Author    : SephirothSpawn
  #   Call Info : Test Angle, Start Angle, End Angle
  #               Radians boolean (if true, converts to degrees)
  #-------------------------------------------------------------------------  
  def self.cw_between_angles?(ang, a1, a2, radians = false)
    # Convert from degrees to radians, if radians
    a1 *= 180 / PI if radians
    a2 *= 180 / PI if radians
    # Make Degrees between 0 - 360
    a1 %= 360 ; a2 %= 360
    # Make a1 Greater than a2
    a1 += 360 if a1 < a2
    # Returns Angle Between Angles
    return ang.between?(a2, 360) || ang.between?(0, a1 - 360) if a1 > 360
    return ang.between?(a2, a1)
  end
  #-------------------------------------------------------------------------
  # * Name      : Angle Between Angles (Counter-Clockwise)
  #   Info      : Returns boolean of angle between 2 angles
  #   Author    : SephirothSpawn
  #   Call Info : Test Angle, Start Angle, End Angle
  #               Radians boolean (if true, converts to degrees)
  #-------------------------------------------------------------------------  
  def self.ccw_between_angles?(ang, a1, a2, radians = false)
    # Convert from degrees to radians, if radians
    a1 *= 180 / PI if radians
    a2 *= 180 / PI if radians
    # Make Degrees between 0 - 360
    a1 %= 360 ; a2 %= 360
    # Make a2 Greater than a1
    a2 += 360 if a2 < a1
    # Returns Angle Between Angles
    return ang.between?(a1, 360) || ang.between?(0, a2 - 360) if a2 > 360
    return ang.between?(a1, a2)
  end
  #-------------------------------------------------------------------------
  # * Name      : Angle Percnt Between Angles (Clockwise)
  #   Info      : Returns boolean of angle between 2 angles
  #   Author    : SephirothSpawn
  #   Call Info : Test Angle, Start Angle, End Angle
  #               Radians boolean (if true, converts to degrees)
  #-------------------------------------------------------------------------  
  def self.cw_percent_between_angles(ang, a1, a2, radians = false)
    # Convert from degrees to radians, if radians
    a1 *= 180 / PI if radians
    a2 *= 180 / PI if radians
    # Make Degrees between 0 - 360
    a1 %= 360 ; a2 %= 360
    # Make aa Greater than a2
    a1 += 360 if a1 < a2
    # Gets Percent
    per = (ang - a2) / (a1 - a2).to_f
    # If Negative, and 360 to Angle
    per = (ang + 360 - a2) / (a1 - a2).to_f if per < 0
    # Return Percent
    return per
  end
  #-------------------------------------------------------------------------
  # * Name      : Angle Percent Between Angles (Counter-Clockwise)
  #   Info      : Returns boolean of angle between 2 angles
  #   Author    : SephirothSpawn
  #   Call Info : Test Angle, Start Angle, End Angle
  #               Radians boolean (if true, converts to degrees)
  #-------------------------------------------------------------------------  
  def self.ccw_percent_between_angles(ang, a1, a2, radians = false)
    # Convert from degrees to radians, if radians
    a1 *= 180 / PI if radians
    a2 *= 180 / PI if radians
    # Make Degrees between 0 - 360
    a1 %= 360 ; a2 %= 360
    # Make a2 Greater than a1
    a2 += 360 if a2 < a1
    # Gets Percent
    per = (ang - a1) / (a2 - a1).to_f
    # If Negative, and 360 to Angle
    per = (ang + 360 - a1) / (a2 - a1).to_f if per < 0
    # Return Percent
    return per
  end
end